<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Microvisor\V1\Device;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Stream;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class DeviceSecretList extends ListResource {
    /**
     * Construct the DeviceSecretList
     *
     * @param Version $version Version that contains the resource
     * @param string $deviceSid A string that uniquely identifies the parent Device.
     */
    public function __construct(Version $version, string $deviceSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['deviceSid' => $deviceSid, ];

        $this->uri = '/Devices/' . \rawurlencode($deviceSid) . '/Secrets';
    }

    /**
     * Streams DeviceSecretInstance records from the API as a generator stream.
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return Stream stream of results
     */
    public function stream(int $limit = null, $pageSize = null): Stream {
        $limits = $this->version->readLimits($limit, $pageSize);

        $page = $this->page($limits['pageSize']);

        return $this->version->stream($page, $limits['limit'], $limits['pageLimit']);
    }

    /**
     * Reads DeviceSecretInstance records from the API as a list.
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return DeviceSecretInstance[] Array of results
     */
    public function read(int $limit = null, $pageSize = null): array {
        return \iterator_to_array($this->stream($limit, $pageSize), false);
    }

    /**
     * Retrieve a single page of DeviceSecretInstance records from the API.
     * Request is executed immediately
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return DeviceSecretPage Page of DeviceSecretInstance
     */
    public function page($pageSize = Values::NONE, string $pageToken = Values::NONE, $pageNumber = Values::NONE): DeviceSecretPage {
        $params = Values::of(['PageToken' => $pageToken, 'Page' => $pageNumber, 'PageSize' => $pageSize, ]);

        $response = $this->version->page('GET', $this->uri, $params);

        return new DeviceSecretPage($this->version, $response, $this->solution);
    }

    /**
     * Retrieve a specific page of DeviceSecretInstance records from the API.
     * Request is executed immediately
     *
     * @param string $targetUrl API-generated URL for the requested results page
     * @return DeviceSecretPage Page of DeviceSecretInstance
     */
    public function getPage(string $targetUrl): DeviceSecretPage {
        $response = $this->version->getDomain()->getClient()->request(
            'GET',
            $targetUrl
        );

        return new DeviceSecretPage($this->version, $response, $this->solution);
    }

    /**
     * Create the DeviceSecretInstance
     *
     * @param string $key The secret key.
     * @param string $value The secret value.
     * @return DeviceSecretInstance Created DeviceSecretInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $key, string $value): DeviceSecretInstance {
        $data = Values::of(['Key' => $key, 'Value' => $value, ]);

        $payload = $this->version->create('POST', $this->uri, [], $data);

        return new DeviceSecretInstance($this->version, $payload, $this->solution['deviceSid']);
    }

    /**
     * Constructs a DeviceSecretContext
     *
     * @param string $key The secret key.
     */
    public function getContext(string $key): DeviceSecretContext {
        return new DeviceSecretContext($this->version, $this->solution['deviceSid'], $key);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Microvisor.V1.DeviceSecretList]';
    }
}