<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta charset="utf-8">
    <link href="<?php echo e(favIcon()); ?>" rel="icon" type="image/png">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="<?php echo e(seo('description') ?? null); ?>">
    <meta name="keywords" content="<?php echo e(seo('keywords') ?? null); ?>">
    <meta name="author" content="<?php echo e(env('AUTHOR')); ?>">
    <meta name="copyright" content="<?php echo e(env('AUTHOR')); ?>">
    <meta name="version" content="<?php echo e(env('VERSION')); ?>">

    
    <meta property="og:title" content="<?php echo $__env->yieldContent('head'); ?>">
    <meta property="og:url" content="<?php echo e(org('company_name') ?? 'Maildoll'); ?>">
    <meta property="og:image" content="<?php echo e(logo()); ?>">
    <meta property="og:type" content="website">
    <meta name="og:description" content="<?php echo e(seo('description') ?? null); ?>">
    <script type="application/ld+json">
        {
          "@context": "http://schema.org",
          "@type": "Organization",
          "url": "https://staging.maildoll.com/",
          "logo": "<?php echo e(favIcon()); ?>"
        }
    </script>

    <title><?php echo e(orgName()); ?></title>

    <?php echo notifyCss(); ?>

    
    <?php echo $__env->make('frontend.argon.layouts.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    


    <?php echo seo('google_analytics') ?? null; ?>


    
    <?php if(checkDBConnection() == true && Schema::hasTable('chatproviders')): ?>
        <?php $__empty_1 = true; $__currentLoopData = chatProviders(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chatProviders): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                echo $chatProviders->body;
            ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <?php endif; ?>
    <?php endif; ?>
    


</head>

<body id="home" dir="<?php echo e(themeDirection() == 'ltr' ? 'ltr' : 'rtl'); ?>">

    <!-- Preloader -->
    <?php echo $__env->renderWhen(true, 'frontend.argon.components.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>
    <!-- End Preloader -->

    <!-- Header -->
    <?php echo $__env->renderWhen(true, 'frontend.argon.components.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>
    <!-- End Header -->

    <?php echo $__env->yieldContent('content'); ?>

    <!-- Footer -->
    <?php echo $__env->renderWhen(true, 'frontend.argon.components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>
    <!-- End Footer -->

    
    <?php echo $__env->make('frontend.argon.layouts.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    <?php echo $__env->yieldContent('scripts'); ?>

    <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if (isset($component)) { $__componentOriginal58ef761b4a8d895ed279bb45cfc348ea = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal58ef761b4a8d895ed279bb45cfc348ea = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'notify::components.notify','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('notify::notify'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal58ef761b4a8d895ed279bb45cfc348ea)): ?>
<?php $attributes = $__attributesOriginal58ef761b4a8d895ed279bb45cfc348ea; ?>
<?php unset($__attributesOriginal58ef761b4a8d895ed279bb45cfc348ea); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal58ef761b4a8d895ed279bb45cfc348ea)): ?>
<?php $component = $__componentOriginal58ef761b4a8d895ed279bb45cfc348ea; ?>
<?php unset($__componentOriginal58ef761b4a8d895ed279bb45cfc348ea); ?>
<?php endif; ?>
    <?php echo notifyJs(); ?>

    <?php echo $__env->yieldPushContent('scripts'); ?>
    <!-- ToTop Button -->
    <button class="scrollup" type="button" onclick=scrollToTop()>
        <i class="ri-arrow-up-fill"></i>
    </button>
</body>

</html>
<?php /**PATH /home/tanbir/office/maildoll/resources/views/frontend/argon/layouts/master.blade.php ENDPATH**/ ?>