<div class="col-span-12 mt-6">
    <div class="intro-y block sm:flex items-center h-10">
        <h2 class="text-lg font-medium truncate mr-5">Weekly Top Senders</h2>

    </div>
    <div class="intro-y overflow-auto lg:overflow-visible mt-8 sm:mt-0">
        <table class="table table-report sm:mt-2">
            <thead>
                <tr>
                    <th class="whitespace-no-wrap">IMAGES</th>
                    <th class="whitespace-no-wrap">USER NAME</th>
                    <th class="text-center whitespace-no-wrap">RECORD</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = weeklyTopSenders(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sender): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php if(isset($sender->user)): ?>
                        <tr class="intro-x">
                            <td class="w-40">
                                <div class="flex">
                                    <div class="w-10 h-10 image-fit zoom-in">
                                        <img alt="<?php echo e($sender?->user?->name ?? 'No User'); ?>" class="tooltip rounded-full"
                                            src="<?php echo e(avatar($sender?->user?->photo ?? '')); ?>"
                                            title="<?php echo e($sender?->user?->name ?? 'No User'); ?>">
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="font-medium whitespace-no-wrap tooltip"
                                    title="<?php echo e($sender?->user?->name ?? 'No User'); ?>"><?php echo e($sender?->user?->name ?? 'No User'); ?></span>
                            </td>
                            <td class="text-center tooltip"
                                title="<?php echo e(weeklyTopSendersRecord($sender?->owner_id) ?? 'No Data'); ?>">
                                <?php echo e(weeklyTopSendersRecord($sender?->owner_id) ?? 'No Data'); ?></td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                    <td colspan="3">
                        <div class="text-center">
                            <img src="<?php echo e(notFound('no-data-found.png')); ?>" class="m-auto no-shadow"
                                alt="#no-data-found">
                        </div>
                    </td>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>
<?php /**PATH /home/tanbir/office/maildoll/resources/views/dashboard/components/weekly_top_senders.blade.php ENDPATH**/ ?>