<!DOCTYPE html>

<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="light">
<!-- BEGIN: Head -->

<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php echo $__env->yieldContent('css'); ?>

    <link rel="stylesheet" href="<?php echo e(filePath('dist/css/app.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(filePath('vendor/mckenziearts/laravel-notify/css/notify.css')); ?>" />
    
   


    

    <?php if(checkDBConnection() == true && Schema::hasTable('organization_setups')): ?>
        <?php if(checkthemeDirection()->exists()): ?>
            <?php if(themeDirection() == 'rtl'): ?>
                <link rel="stylesheet" href="<?php echo e(filePath('assets/css/rtl.css')); ?>">
            <?php endif; ?>
        <?php endif; ?>
    <?php endif; ?>

    



    <link rel="stylesheet" href="<?php echo e(filePath('assets/css/chatCustom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(filePath('assets/css/style.css')); ?>">

    <?php if(checkDBConnection() == true && Schema::hasTable('organization_setups')): ?>
        <?php if(checkthemeLayout()->exists()): ?>
            <?php if(themeLayout() == 'classic'): ?>
                <link rel="stylesheet" href="<?php echo e(filePath('assets/css/classic.css')); ?>">
            <?php else: ?>
                <style>
                    .app {
                        background-color: {
                                {
                                color()
                            }
                        }

                        ;
                    }
                </style>
            <?php endif; ?>
        <?php else: ?>
            <link rel="stylesheet" href="<?php echo e(filePath('assets/css/classic.css')); ?>">
        <?php endif; ?>
    <?php endif; ?>


    <meta property="og:title" content="<?php echo $__env->yieldContent('head'); ?>">
    <meta property="og:type" content="website">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">




    <?php if(checkDBConnection() == true && Schema::hasTable('organization_setups')): ?>
        <?php if(Schema::hasColumn('organization_setups', 'company_name') || Schema::hasColumn('organization_setups', 'logo')): ?>
            <link href="<?php echo e(favIcon()); ?>" rel="shortcut icon">
            <meta property="og:url" content="<?php echo e(org('company_name') ?? 'Maildoll'); ?>">
            <meta property="og:image" content="<?php echo e(logo()); ?>">
        <?php else: ?>
            <link href="<?php echo e(favIcon()); ?>" rel="shortcut icon">
        <?php endif; ?>
    <?php endif; ?>

    <?php if(checkDBConnection() == true && Schema::hasTable('seos')): ?>
        <meta name="description" content="<?php echo e(seo('description') ?? null); ?>">
        <meta name="keywords" content="<?php echo e(seo('keywords') ?? null); ?>">

        
        <meta name="og:description" content="<?php echo e(seo('description') ?? null); ?>">
    <?php endif; ?>

    <?php echo $__env->yieldContent('head'); ?>

    <script src="<?php echo e(filePath('bladejs/google-translate.js')); ?>"></script>

    <?php echo notifyCss(); ?>

    <!-- END: CSS Assets-->
</head>
<!-- END: Head -->

<?php echo $__env->yieldContent('body'); ?>

<?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php if (isset($component)) { $__componentOriginal58ef761b4a8d895ed279bb45cfc348ea = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal58ef761b4a8d895ed279bb45cfc348ea = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'notify::components.notify','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('notify::notify'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal58ef761b4a8d895ed279bb45cfc348ea)): ?>
<?php $attributes = $__attributesOriginal58ef761b4a8d895ed279bb45cfc348ea; ?>
<?php unset($__attributesOriginal58ef761b4a8d895ed279bb45cfc348ea); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal58ef761b4a8d895ed279bb45cfc348ea)): ?>
<?php $component = $__componentOriginal58ef761b4a8d895ed279bb45cfc348ea; ?>
<?php unset($__componentOriginal58ef761b4a8d895ed279bb45cfc348ea); ?>
<?php endif; ?>
<?php echo notifyJs(); ?>

</html>
<?php /**PATH /home/tanbir/office/maildoll/resources/views////layout/base.blade.php ENDPATH**/ ?>