<!DOCTYPE html>

<html lang="en" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:v="urn:schemas-microsoft-com:vml">

<head>
	<title></title>
	<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
	<meta content="width=device-width, initial-scale=1.0" name="viewport" />
	<link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Abril+Fatface" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Merriweather" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Montserrat" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Bitter" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Permanent+Marker" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Roboto+Slab" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Cabin" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Oxygen" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Oswald" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Ubuntu" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Open+Sans" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Droid+Serif" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Playfair+Display" rel="stylesheet" type="text/css" />
	<link href="https://fonts.googleapis.com/css?family=Poppins" rel="stylesheet" type="text/css" />
	<!--<![endif]-->
	<style>
		
		* {
			box-sizing: border-box;
		}

		body {
			margin: 0;
			padding: 0;
		}

		a[x-apple-data-detectors] {
			color: inherit !important;
			text-decoration: inherit !important;
		}

		#MessageViewBody a {
			color: inherit;
			text-decoration: none;
		}

		p {
			line-height: inherit
		}

		.desktop_hide,
		.desktop_hide table {
			mso-hide: all;
			display: none;
			max-height: 0px;
			overflow: hidden;
		}

		@media (max-width:700px) {
			.desktop_hide table.icons-inner {
				display: inline-block !important;
			}

			.icons-inner {
				text-align: center;
			}

			.icons-inner td {
				margin: 0 auto;
			}

			.row-content {
				width: 100% !important;
			}

			.mobile_hide {
				display: none;
			}

			.stack .column {
				width: 100%;
				display: block;
			}

			.mobile_hide {
				min-height: 0;
				max-height: 0;
				max-width: 0;
				overflow: hidden;
				font-size: 0px;
			}

			.desktop_hide,
			.desktop_hide table {
				display: table !important;
				max-height: none !important;
			}

			.row-1 .column-1 .block-3.heading_block td.pad {
				padding: 10px 60px 30px !important;
			}

			.row-1 .column-1 .block-3.heading_block h2 {
				font-size: 33px !important;
			}
		}
	</style>
</head>

<body style="background-color: #1a30eb; margin: 0; padding: 0; -webkit-text-size-adjust: none; text-size-adjust: none;">
	<table border="0" cellpadding="0" cellspacing="0" class="nl-container" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #1a30eb;" width="100%">
		<tbody>
			<tr>
				<td>
					<table align="center" border="0" cellpadding="0" cellspacing="0" class="row row-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-size: auto;" width="100%">
						<tbody>
							<tr>
								<td>
									<table align="center" border="0" cellpadding="0" cellspacing="0" class="row-content stack" role="presentation"
										style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-size: auto; background-color: #ffffff; color: #000000; border-bottom: 0 solid #FFFFFF; border-left: 0 solid #FFFFFF; border-radius: 30px 30px 0 0; border-right: 0px solid #FFFFFF; border-top: 0 solid #FFFFFF; width: 680px;"
										width="680">
										<tbody>
											<tr>
												<td class="column column-1" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; vertical-align: top; padding-top: 0px; padding-bottom: 0px; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;" width="100%">
													<table border="0" cellpadding="0" cellspacing="0" class="image_block block-1" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%">
														<tr>
															<td class="pad" style="width:100%;padding-right:0px;padding-left:0px;">
																<div align="center" class="alignment" style="line-height:10px"><img src="{{ filePath('maildoll-logo.png') }}" style="display: block; height: auto; border: 0; width: 258px; max-width: 100%;" width="258" /></div>
															</td>
														</tr>
													</table>
													<table border="0" cellpadding="0" cellspacing="0" class="heading_block block-3" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%">
														<tr>
															<td class="pad" style="padding-bottom:30px;padding-left:60px;padding-right:60px;padding-top:70px;text-align:center;width:100%;">
																<h2 style="margin: 0; color: #8a3c90; font-size: 30px; font-family: Poppins, Arial, Helvetica, sans-serif; line-height: 120%; text-align: center; direction: ltr; font-weight: 700; letter-spacing: normal; margin-top: 0; margin-bottom: 0;">
																	Monthly Mail Report Summary</h2>
															</td>
														</tr>
													</table>
													<table border="0" cellpadding="0" cellspacing="0" class="html_block block-4" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%">
														<tr>
															<td class="pad">
																<div align="center" style="font-family:Poppins, Arial, Helvetica, sans-serif;text-align:center;">
																	<style>
																		.TableHead {
																			box-sizing: border-box;
																			width: 1302.49px;
																			height: 50px;
																			background: #F9F9F9;
																			border: 1px solid #DDE0E2;
																			border-style: solid !important;
																			border-width: thin !important;
																		}

																		th {
																			border-top: 1px solid #dddddd;
																			border-bottom: 1px solid #dddddd;
																			border-right: 1px solid #dddddd;
																		}

																		th:first-child {
																			border-left: 1px solid #dddddd;
																		}

																		tbody:before {
																			content: "@";
																			display: block;
																			line-height: 10px;
																			text-indent: -99999px;
																		}

																		.firstRow {
																			box-sizing: border-box;
																			/* position: absolute; */
																			width: 1302.49px;
																			height: 55px;
																			left: 309.54px;
																			top: 404.06px;
																			background: #FFFFFF;
																			border-width: 1px 1px 1px 1px !important;
																			border-style: solid !important;
																			border-color: #DDE0E2 !important;
																		}

																		/* Button Style */
																		h1 {
																			font-size: 42px;
																			color: #2c3e50;
																		}

																		input[type="checkbox"] {
																			position: relative;
																			width: 80px;
																			height: 30px;
																			-webkit-appearance: none;
																			border-radius: 20px;
																			outline: none;
																			transition: .4s;
																			box-shadow: inset 0 0 5px rgba(0, 0, 0, 0.2);
																			cursor: pointer;
																		}

																		input:checked[type="checkbox"] {
																			background: green;
																		}

																		input[type="checkbox"]::before {
																			z-index: 2;
																			position: absolute;
																			content: "";
																			left: 0;
																			width: 30px;
																			height: 30px;
																			background: #8E9AA0;
																			border-radius: 50%;
																			transform: scale(1.1);
																			box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
																			transition: .4s;
																		}

																		input:checked[type="checkbox"]::before {
																			left: 50px;
																			background: #FFFFFF;
																		}

																		.toggle {
																			position: relative;
																			display: inline;
																		}

																		label {
																			position: absolute;
																			color: #fff;
																			font-weight: 600;
																			pointer-events: none;
																		}

																		.onbtn {
																			bottom: 0px;
																			left: 11px;
																		}

																		.ofbtn {
																			bottom: 0px;
																			right: 8px;
																			color: #8E9AA0;
																		}
																	</style>
																	<div class="row">
																		<div class="col-lg-12">
																			<table class="table cell-border" id="exampl" style="width:100%">
																				<thead class="TableHead">
																					<tr>
																						<th>CAMPAIGN</th>
																						<th>EMAILS</th>
																						<th>CLICKS</th>
																						<th>DELIVERED</th>
																						<th>OPEN RATE</th>
																					</tr>
																				</thead>
																				<tbody>

																					@forelse ($campaigns as $campaign)
																						<tr class="firstRow">
																							<td>{{ $campaign->campaign_name->name }}</td>
																							<td>{{ campaignTracker($campaign->campaign_id)->total }}</td>
																							<td>{{ campaignEmailTotalClicks($campaign->campaign_id) }}</td>
																							<td>{{ campaignEmailDelivered($campaign->campaign_id) }}/{{ campaignEmailNotOpenedAndNotOpen($campaign->campaign_id) }}</td>
																							<td> {{ campaignEmailDelivered($campaign->campaign_id) }}/{{ campaignEmailNotOpenedAndNotOpen($campaign->campaign_id) }}</td>
																						</tr>
																					@empty
																						<td colspan="5">
																							<div class="text-center">
																								<img src="{{ notFound('log.png') }}" class="m-auto no-shadow" alt="#campaign-not-found">
																							</div>
																						</td>
																					@endforelse
																				</tbody>
																			</table>
																		</div>
																	</div>
																</div>
															</td>
														</tr>
													</table>
													<table border="0" cellpadding="0" cellspacing="0" class="html_block block-5" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;" width="100%">
														<tr>
															<td class="pad">
																<div align="center" style="font-family:Poppins, Arial, Helvetica, sans-serif;text-align:center; margin-bottom: 30px;">
																	<span>{{ now()->format('l') }}
																		{{ date('d-m-Y') }}</span>
																</div>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
		</tbody>
	</table><!-- End -->

</body>

</html>
