<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmsTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('sms', function (Blueprint $table) {
            $table->id();
            $table->longText('sms_name')->nullable();
            $table->longText('sms_id')->nullable();
            $table->longText('sms_token')->nullable();
            $table->longText('sms_from')->nullable();
            $table->longText('sms_number')->nullable();
            $table->longText('url')->nullable();
            $table->unsignedBigInteger('owner_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('sms');
    }
}
