<?php $__env->startSection('head'); ?>
    <?php echo $__env->yieldContent('subhead'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('../layout/components/mobile-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="flex relative">
        <!-- BEGIN: Side Menu -->
        <nav class="side-nav" id="maildoll_sidebar_id">
            <a href="<?php echo e(route('dashboard')); ?>" class="intro-x flex items-center text-gray-50 hide-less-768"
                style="justify-content: center;">
                <img src="<?php echo e(logo()); ?>" alt="<?php echo e(orgName()); ?>" width="210" height="70" class="rounded">
            </a>
            <div class="side-nav__devider my-6 hide-less-768"></div>

            

            
            <ul class="hidden">
                
                <li>
                    <a href="<?php echo e(route('dashboard')); ?>"
                        class="side-menu <?php echo e(request()->routeIs('dashboard') ? 'side-menu--active' : ''); ?>">
                        <div class="<?php echo e(request()->routeIs('dashboard') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                            <div class="side-menu__icon">
                                <i data-feather="home"></i>
                            </div>
                            <div class="side-menu__title">
                                Dashboard
                            </div>
                        </div>
                    </a>
                </li>


                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
                    <?php if(env('MARKETPLACE') == 'YES'): ?>
                        <li>
                            <a href="<?php echo e(route('marketplace.index')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('marketplace.*') ? 'side-menu--active' : ''); ?>">
                                <div
                                    class="<?php echo e(request()->routeIs('marketplace.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="shopping-bag"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Marketplace

                                        <?php if(marketplace_today_new_buyer_count() > 0): ?>
                                            <span class="ml-1">
                                                (<?php echo e(marketplace_today_new_buyer_count()); ?>)
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>


                <li>
                    <a href="<?php echo e(route('profile.index')); ?>"
                        class="side-menu <?php echo e(request()->routeIs('profile.index') ? 'side-menu--active' : ''); ?>">
                        <div class="<?php echo e(request()->routeIs('profile.index') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                            <div class="side-menu__icon">
                                <i data-feather="user"></i>
                            </div>
                            <div class="side-menu__title">
                                My Profile
                            </div>
                        </div>
                    </a>
                </li>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
                    <li>
                        <a href="<?php echo e(route('org.index')); ?>"
                            class="side-menu <?php echo e(request()->routeIs('org.index') ? 'side-menu--active' : ''); ?>">
                            <div class="<?php echo e(request()->routeIs('org.index') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="tool"></i>
                                </div>
                                <div class="side-menu__title">
                                    Organization Setup
                                </div>
                            </div>
                        </a>
                    </li>

                    <li>
                        <a href="<?php echo e(route('system.smtp.configure')); ?>"
                            class="side-menu <?php echo e(request()->routeIs('system.smtp.configure') ? 'side-menu--active' : ''); ?>">
                            <div
                                class="<?php echo e(request()->routeIs('system.smtp.configure') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="wind"></i>
                                </div>
                                <div class="side-menu__title">
                                    Application SMTP
                                </div>
                            </div>
                        </a>
                    </li>



                    

                    <li>
                        <a href="javascript:;"
                            class="side-menu <?php echo e(request()->routeIs('frontend.*') ? 'side-menu--active side-menu--open' : ''); ?>">
                            <div class="<?php echo e(request()->routeIs('frontend.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="sun"></i>
                                </div>
                                <div class="side-menu__title">
                                    Frontend
                                    <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                                </div>
                            </div>
                        </a>

                        <ul class="d-none <?php echo e(request()->routeIs('frontend.setup') ? 'side-menu__sub-open' : ''); ?>">
                            <?php if(theme() != 'argon'): ?>
                                <li>
                                    <a href="<?php echo e(route('frontend.setup')); ?>" target="_blank"
                                        class="side-menu <?php echo e(request()->routeIs('frontend.setup') ? 'side-menu--active' : ''); ?>">
                                        <div
                                            class="<?php echo e(request()->routeIs('frontend.setup') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                            <div class="side-menu__icon">
                                                <i data-feather="align-left"></i>
                                            </div>
                                            <div class="side-menu__title">
                                                Neon Setup
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            <?php else: ?>
                                <li>
                                    <a href="<?php echo e(route('frontend.index')); ?>" target="_blank"
                                        class="side-menu <?php echo e(request()->routeIs('frontend.index') ? 'side-menu--active' : ''); ?>">
                                        <div
                                            class="<?php echo e(request()->routeIs('frontend.index') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                            <div class="side-menu__icon">
                                                <i data-feather="align-left"></i>
                                            </div>
                                            <div class="side-menu__title">
                                                Argon Setup
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </li>

                    

                    <li class="">
                        <a href="javascript:;"
                            class="side-menu <?php echo e(request()->routeIs('language.index*') ? 'side-menu--active side-menu--open' : ''); ?>">
                            <div class="<?php echo e(request()->routeIs('language.index') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="type"></i>
                                </div>
                                <div class="side-menu__title">
                                    Language Settings
                                    <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                                </div>
                            </div>
                        </a>

                        <ul
                            class="<?php echo e(request()->routeIs('language.index*') || request()->routeIs('language.translate') ? 'side-menu__sub-open' : ''); ?>">
                            <li>
                                <a href="<?php echo e(route('language.index')); ?>"
                                    class="side-menu <?php echo e(request()->routeIs('language.index') ? 'side-menu--active' : ''); ?>">

                                    <div class="side-menu__icon">
                                        <i data-feather="align-left"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Setup Language
                                    </div>

                                </a>
                            </li>
                        </ul>
                    </li>

                    

                    <li>
                        <a href="javascript:;"
                            class="side-menu <?php echo e(request()->routeIs('currencies.index*') ? 'side-menu--active side-menu--open' : ''); ?>">
                            <div
                                class="<?php echo e(request()->routeIs('currencies.index') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="dollar-sign"></i>
                                </div>
                                <div class="side-menu__title">
                                    Currency Settings
                                    <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                                </div>
                            </div>
                        </a>

                        <ul class="d-none <?php echo e(request()->routeIs('currencies.index*') ? 'side-menu__sub-open' : ''); ?>">
                            <li>
                                <a href="<?php echo e(route('currencies.index')); ?>"
                                    class="side-menu <?php echo e(request()->routeIs('currencies.index') ? 'side-menu--active' : ''); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="align-left"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Setup Currency
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                <?php endif; ?>

                

                <li>
                    <a href="javascript:;"
                        class="side-menu <?php echo e(request()->routeIs('smtp.index*') ? 'side-menu--active side-menu--open' : ''); ?>">
                        <div class="<?php echo e(request()->routeIs('smtp.index') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                            <div class="side-menu__icon">
                                <i data-feather="mail"></i>
                            </div>
                            <div class="side-menu__title">
                                Mail Servers
                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                            </div>
                        </div>
                    </a>

                    <ul class="d-none <?php echo e(request()->routeIs('smtp.*') ? 'side-menu__sub-open' : ''); ?>">
                        <li>
                            <a href="<?php echo e(route('smtp.index')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('smtp.index') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Configure Server
                                </div>
                            </a>
                        </li>

                    </ul>
                </li>

                

                <li>
                    <a href="javascript:;"
                        class="side-menu <?php echo e(request()->routeIs('sms.*') ? 'side-menu--active side-menu--open' : ''); ?>">
                        <div class="<?php echo e(request()->routeIs('sms.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                            <div class="side-menu__icon">
                                <i data-feather="smartphone"></i>
                            </div>
                            <div class="side-menu__title">
                                SMS Settings
                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                            </div>
                        </div>
                    </a>

                    <ul class="d-none <?php echo e(request()->routeIs('sms.*') ? 'side-menu__sub-open' : ''); ?>">
                        <li>
                            <a href="<?php echo e(route('sms.index')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('sms.index') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Configure SMS
                                </div>
                            </a>
                        </li>

                    </ul>
                </li>

                <?php if(env('VOICE_ACTIVE') == 'YES'): ?>
                    

                    <li>
                        <a href="javascript:;"
                            class="side-menu <?php echo e(request()->routeIs('twilio.voice.*') ? 'side-menu--active side-menu--open' : ''); ?>">
                            <div
                                class="<?php echo e(request()->routeIs('twilio.voice.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="phone-call"></i>
                                </div>
                                <div class="side-menu__title">
                                    Voice Servers
                                    <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                                </div>
                            </div>
                        </a>

                        <ul class="d-none <?php echo e(request()->routeIs('twilio.voice.*') ? 'side-menu__sub-open' : ''); ?>">
                            <li>
                                <a href="<?php echo e(route('twilio.voice.index')); ?>"
                                    class="side-menu <?php echo e(request()->routeIs('twilio.voice.index') ? 'side-menu--active' : ''); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="align-left"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Configure Servers
                                    </div>
                                </a>
                            </li>

                        </ul>
                    </li>
                <?php endif; ?>

                

                <li>

                    <a href="javascript:;"
                        class="side-menu <?php echo e(request()->routeIs('templates.*') || request()->routeIs('template.builder.*') ? 'side-menu--active side-menu--open' : ''); ?>">
                        <div class="<?php echo e(request()->routeIs('templates.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">

                            <div class="side-menu__icon">
                                <i data-feather="git-pull-request"></i>
                            </div>
                            <div class="side-menu__title">
                                Template Builder
                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                            </div>

                        </div>
                    </a>

                    <ul
                        class="d-none <?php echo e(request()->routeIs('templates.*') || request()->routeIs('template.builder.*') ? 'side-menu__sub-open' : ''); ?>">
                        <li>

                            <a href="<?php echo e(route('template.builder.originate')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('template.builder.originate') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Create Template
                                </div>
                            </a>

                            <a href="<?php echo e(route('templates.index')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('templates.index') || request()->routeIs('template.builder.edit.thumbnail') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="book"></i>
                                </div>
                                <div class="side-menu__title">
                                    Template List
                                </div>
                            </a>

                        </li>
                    </ul>
                </li>

                

                <li>
                    <a href="javascript:;"
                        class="side-menu <?php echo e(request()->routeIs('builder.sms.*') ? 'side-menu--active side-menu--open' : ''); ?>">
                        <div class="<?php echo e(request()->routeIs('builder.sms.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">

                            <div class="side-menu__icon">
                                <i data-feather="git-merge"></i>
                            </div>
                            <div class="side-menu__title">
                                SMS Builder
                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                            </div>
                        </div>

                    </a>

                    <ul class="d-none <?php echo e(request()->routeIs('builder.sms.*') ? 'side-menu__sub-open' : ''); ?>">
                        <li>
                            <a href="<?php echo e(route('builder.sms.create')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('builder.sms.create') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Create Body
                                </div>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('builder.sms.templates')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('builder.sms.templates') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    SMS Templates
                                </div>
                            </a>

                        </li>

                    </ul>
                </li>

                

                <li>
                    <a href="javascript:;"
                        class="side-menu <?php echo e(request()->routeIs('email.contacts*') || request()->routeIs('email.contacts.list') || request()->routeIs('phone.contacts.list') ? 'side-menu--active side-menu--open' : ''); ?>">

                        <div
                            class="<?php echo e(request()->routeIs('email.contacts*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                            <div class="side-menu__icon">
                                <i data-feather="send"></i>
                            </div>
                            <div class="side-menu__title">
                                Contacts
                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                            </div>
                        </div>

                    </a>

                    <ul
                        class="d-none <?php echo e(request()->routeIs('email.contacts*') || request()->routeIs('email.contact.show') || request()->routeIs('email.contacts.list') || request()->routeIs('phone.contacts.list') ? 'side-menu__sub-open' : ''); ?>">
                        <li>
                            <a href="<?php echo e(route('email.contacts.index')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('email.contacts.index') || request()->routeIs('email.contact.show') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Contact List
                                </div>
                            </a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('email.contacts.list')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('email.contacts.list') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Email List
                                </div>
                            </a>
                        </li>


                        <li>
                            <a href="<?php echo e(route('phone.contacts.list')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('phone.contacts.list') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Phone List
                                </div>
                            </a>
                        </li>


                        <li>
                            <a href="<?php echo e(route('email.contacts.bulk.csv')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('email.contacts.bulk.csv') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Bulk Import Export
                                </div>
                            </a>
                        </li>

                    </ul>
                </li>

                

                <li>
                    <a href="javascript:;"
                        class="side-menu <?php echo e(request()->routeIs('group.*') ? 'side-menu--active side-menu--open' : ''); ?>">

                        <div class="<?php echo e(request()->routeIs('group.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                            <div class="side-menu__icon">
                                <i data-feather="users"></i>
                            </div>
                            <div class="side-menu__title">
                                Groups
                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                            </div>
                        </div>

                    </a>

                    <ul class="d-none <?php echo e(request()->routeIs('group.*') ? 'side-menu__sub-open' : ''); ?>">
                        <li>
                            <a href="<?php echo e(route('group.index')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('group.index') || request()->routeIs('group.show') || request()->routeIs('group.edit') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Group List
                                </div>
                            </a>
                            <a href="<?php echo e(route('group.create')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('group.create') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Create Group
                                </div>
                            </a>
                        </li>

                    </ul>
                </li>

                
                <li>
                    <a href="<?php echo e(route('autoresponder.index')); ?>"
                        class="side-menu <?php echo e(request()->routeIs('autoresponder.*') ? 'side-menu--active' : ''); ?>">
                        <div
                            class="<?php echo e(request()->routeIs('autoresponder.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                            <div class="side-menu__icon">
                                <i data-feather="share-2"></i>
                            </div>
                            <div class="side-menu__title">
                                Autoresponder
                            </div>
                        </div>
                    </a>
                </li>

                

                <li>
                    <a href="javascript:;"
                        class="side-menu <?php echo e(request()->routeIs('campaign.*') ? 'side-menu--active side-menu--open' : ''); ?>">

                        <div class="<?php echo e(request()->routeIs('campaign.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                            <div class="side-menu__icon">
                                <i data-feather="columns"></i>
                            </div>
                            <div class="side-menu__title">
                                Campaigns
                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                            </div>

                        </div>
                    </a>

                    <ul
                        class="d-none <?php echo e(request()->routeIs('campaign.*') || request()->routeIs('tracker.*') ? 'side-menu__sub-open' : ''); ?>">
                        <li>
                            <a href="<?php echo e(route('campaign.type', 'email')); ?>"
                                class="side-menu <?php echo e(request()->is('campaign/type/email') || request()->routeIs('campaign.emails.edit') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Email Campaign
                                </div>
                            </a>
                            <a href="<?php echo e(route('campaign.type', 'sms')); ?>"
                                class="side-menu <?php echo e(request()->is('campaign/type/sms') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    SMS Campaign
                                </div>
                            </a>

                            <a href="<?php echo e(route('campaign.index')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('campaign.index') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Campaign List
                                </div>
                            </a>

                            <a href="<?php echo e(route('campaign.create')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('campaign.create') ||
                                request()->routeIs('campaign.create.type') ||
                                request()->routeIs('campaign.store.step1') ||
                                request()->routeIs('campaign.store.step2') ||
                                request()->routeIs('campaign.store.store2') ||
                                request()->routeIs('campaign.store.step3')
                                    ? 'side-menu--active'
                                    : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Create Campaign
                                </div>
                            </a>

                            

                            <a href="<?php echo e(route('campaign.schedule.emails')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('campaign.schedule.emails') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Email Schedules
                                </div>
                            </a>

                            

                            

                            <a href="<?php echo e(route('tracker.emails.index')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('tracker.*') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Campaign Tracker
                                </div>
                            </a>

                            

                        </li>

                    </ul>
                </li>

                

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
                    <li>
                        <a href="javascript:;"
                            class="side-menu <?php echo e(request()->routeIs('mail.activity.*') ? 'side-menu--active side-menu--open' : ''); ?>">
                            <div
                                class="<?php echo e(request()->routeIs('mail.activity.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">

                                <div class="side-menu__icon">
                                    <i data-feather="list"></i>
                                </div>
                                <div class="side-menu__title">
                                    Mail Details
                                    <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                                </div>

                            </div>
                        </a>

                        <ul class="d-none <?php echo e(request()->routeIs('mail.activity.*') ? 'side-menu__sub-open' : ''); ?>">

                            <li>
                                <a href="<?php echo e(route('mail.activity.index')); ?>"
                                    class="side-menu <?php echo e(request()->routeIs('mail.activity.index') ? 'side-menu--active' : ''); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="align-left"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Detail List
                                    </div>
                                </a>
                            </li>

                        </ul>
                    </li>
                <?php endif; ?>

                

                <li>
                    <a href="javascript:;"
                        class="side-menu <?php echo e(request()->routeIs('log.sms') ? 'side-menu--active side-menu--open' : ''); ?>">

                        <div class="<?php echo e(request()->routeIs('log.sms') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                            <div class="side-menu__icon">
                                <i data-feather="message-square"></i>
                            </div>
                            <div class="side-menu__title">
                                SMS Logs
                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                            </div>
                        </div>

                    </a>

                    <ul class="d-none <?php echo e(request()->routeIs('log.sms') ? 'side-menu__sub-open' : ''); ?>">

                        <li>
                            <a href="<?php echo e(route('log.sms')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('log.sms') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Log List
                                </div>
                            </a>
                        </li>

                        <li class="hidden">
                            <a href="<?php echo e(route('log.sms.infobip')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('log.sms.infobip') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    InfoBip Log List
                                </div>
                            </a>
                        </li>

                    </ul>
                </li>

                

                <li>
                    <a href="javascript:;"
                        class="side-menu <?php echo e(request()->routeIs('logs.campaign.*') ? 'side-menu--active side-menu--open' : ''); ?>">

                        <div
                            class="<?php echo e(request()->routeIs('logs.campaign.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                            <div class="side-menu__icon">
                                <i data-feather="activity"></i>
                            </div>
                            <div class="side-menu__title">
                                Campaign Logs
                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                            </div>
                        </div>

                    </a>

                    <ul class="d-none <?php echo e(request()->routeIs('logs.campaign.*') ? 'side-menu__sub-open' : ''); ?>">

                        <li>
                            <a href="<?php echo e(route('logs.campaign.index')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('logs.campaign.index') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Log List
                                </div>
                            </a>
                        </li>

                    </ul>
                </li>

                


                <?php if(!saas()): ?>
                    

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
                        <li>
                            <a href="javascript:;"
                                class="side-menu <?php echo e(request()->routeIs('subscription.*') ? 'side-menu--active side-menu--open' : ''); ?>">

                                <div
                                    class="<?php echo e(request()->routeIs('subscription.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="grid"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Subscription Plans
                                        <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                                    </div>

                                </div>
                            </a>

                            <ul class="d-none <?php echo e(request()->routeIs('subscription.*') ? 'side-menu__sub-open' : ''); ?>">

                                <li>
                                    <a href="<?php echo e(route('subscription.index')); ?>"
                                        class="side-menu <?php echo e(request()->routeIs('subscription.index') || request()->routeIs('subscription.edit') ? 'side-menu--active' : ''); ?>">
                                        <div class="side-menu__icon">
                                            <i data-feather="align-left"></i>
                                        </div>
                                        <div class="side-menu__title">
                                            Plans
                                        </div>
                                    </a>
                                </li>

                            </ul>
                        </li>
                    <?php endif; ?>

                    


                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Customer')): ?>
                        <li>
                            <a href="<?php echo e(route('purchased.plan')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('purchased.plan') ? 'side-menu--active' : ''); ?>">
                                <div
                                    class="<?php echo e(request()->routeIs('purchased.plan') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="shopping-bag"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Purchased Plans
                                    </div>
                                </div>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>


                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
                    <?php if(!saas()): ?>
                        <li>
                            <a href="javascript:;"
                                class="side-menu <?php echo e(request()->routeIs('limit.*') ? 'side-menu--active side-menu--open' : ''); ?>">

                                <div class="<?php echo e(request()->routeIs('limit.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="bar-chart-2"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Limit Manager
                                        <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                                    </div>

                                </div>
                            </a>

                            <ul class="d-none <?php echo e(request()->routeIs('limit.*') ? 'side-menu__sub-open' : ''); ?>">

                                <li>
                                    <a href="<?php echo e(route('limit.index')); ?>"
                                        class="side-menu <?php echo e(request()->routeIs('limit.index') ? 'side-menu--active' : ''); ?>">
                                        <div class="side-menu__icon">
                                            <i data-feather="align-left"></i>
                                        </div>
                                        <div class="side-menu__title">
                                            Users Limit
                                        </div>
                                    </a>
                                </li>

                            </ul>
                        </li>
                    <?php endif; ?>

                    

                    <li>
                        <a href="javascript:;"
                            class="side-menu <?php echo e(request()->routeIs('notes.*') ? 'side-menu--active side-menu--open' : ''); ?>">
                            <div class="<?php echo e(request()->routeIs('notes.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">

                                <div class="side-menu__icon">
                                    <i data-feather="book"></i>
                                </div>
                                <div class="side-menu__title">
                                    Important Notes
                                    <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                                </div>
                            </div>

                        </a>

                        <ul class="d-none <?php echo e(request()->routeIs('notes.*') ? 'side-menu__sub-open' : ''); ?>">

                            <li>
                                <a href="<?php echo e(route('notes.index')); ?>"
                                    class="side-menu <?php echo e(request()->routeIs('notes.index') || request()->routeIs('notes.show') || request()->routeIs('notes.edit') ? 'side-menu--active' : ''); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="align-left"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Note Lists
                                    </div>
                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('notes.create')); ?>"
                                    class="side-menu <?php echo e(request()->routeIs('notes.create') ? 'side-menu--active' : ''); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="align-left"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Create Note
                                    </div>
                                </a>
                            </li>

                        </ul>
                    </li>

                    

                    <li>
                        <a href="javascript:;"
                            class="side-menu <?php echo e(request()->routeIs('payment.setup.*') ? 'side-menu--active side-menu--open' : ''); ?>">
                            <div
                                class="<?php echo e(request()->routeIs('payment.setup.*') ? 'mldl-active-menu' : 'flex items-center'); ?>">

                                <div class="side-menu__icon">
                                    <i data-feather="credit-card"></i>
                                </div>
                                <div class="side-menu__title">
                                    Payment Setup
                                    <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                                </div>
                            </div>

                        </a>

                        <ul class="d-none <?php echo e(request()->routeIs('payment.setup.*') ? 'side-menu__sub-open' : ''); ?>">

                            <li>
                                <a href="<?php echo e(route('payment.setup.paypal')); ?>"
                                    class="side-menu <?php echo e(request()->routeIs('payment.setup.paypal') ? 'side-menu--active' : ''); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="align-left"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Paypal
                                    </div>
                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('payment.setup.stripe')); ?>"
                                    class="side-menu <?php echo e(request()->routeIs('payment.setup.stripe') ? 'side-menu--active' : ''); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="align-left"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Stripe
                                    </div>
                                </a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('payment.setup.khalti')); ?>"
                                    class="side-menu <?php echo e(request()->routeIs('payment.setup.khalti') ? 'side-menu--active' : ''); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="align-left"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Khalti
                                    </div>
                                </a>
                            </li>

                        </ul>
                    </li>
                <?php endif; ?>

                

                <li>
                    <a href="javascript:;"
                        class="side-menu <?php echo e(request()->routeIs('bounce.emails') ? 'side-menu--active side-menu--open' : ''); ?>">
                        <div
                            class="<?php echo e(request()->routeIs('bounce.emails') ? 'mldl-active-menu' : 'flex items-center'); ?>">

                            <div class="side-menu__icon">
                                <i data-feather="alert-circle"></i>
                            </div>
                            <div class="side-menu__title">
                                Bounce Checker
                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                            </div>
                        </div>

                    </a>

                    <ul class="d-none <?php echo e(request()->routeIs('bounce.*') ? 'side-menu__sub-open' : ''); ?>">

                        <li>
                            <a href="<?php echo e(route('bounce.emails')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('bounce.emails') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Email Lists
                                </div>
                            </a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('bounce.check')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('bounce.check') ? 'side-menu--active' : ''); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="align-left"></i>
                                </div>
                                <div class="side-menu__title">
                                    Check Bounce
                                </div>
                            </a>
                        </li>

                    </ul>
                </li>

                

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
                    
                    <li>
                        <a href="<?php echo e(route('seo.index')); ?>"
                            class="side-menu <?php echo e(request()->routeIs('seo.index') ? 'side-menu--active' : ''); ?>">
                            <div class="<?php echo e(request()->routeIs('seo.index') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                <div class="side-menu__icon">
                                    <i data-feather="bar-chart"></i>
                                </div>
                                <div class="side-menu__title">
                                    SEO
                                </div>
                            </div>
                        </a>
                    </li>

                    <?php if(devtool()): ?>
                        

                        <li>
                            <a href="<?php echo e(route('chat.provider')); ?>"
                                class="side-menu
                    <?php echo e(request()->routeIs('chat.provider') || request()->routeIs('chat.edit') ? 'side-menu--active' : ''); ?>">

                                <div
                                    class="<?php echo e(request()->routeIs('chat.provider') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="message-square"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Chat Provider
                                    </div>
                                </div>
                            </a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('server.status')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('server.status') ? 'side-menu--active' : ''); ?>">

                                <div
                                    class="<?php echo e(request()->routeIs('server.status') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="server"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Server Status
                                    </div>
                                </div>
                            </a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('help')); ?>"
                                class="side-menu <?php echo e(request()->routeIs('help') ? 'side-menu--active' : ''); ?>">

                                <div class="<?php echo e(request()->routeIs('help') ? 'mldl-active-menu' : 'flex items-center'); ?>">
                                    <div class="side-menu__icon">
                                        <i data-feather="help-circle"></i>
                                    </div>
                                    <div class="side-menu__title">
                                        Help
                                    </div>
                                </div>
                            </a>
                        </li>

                        
                    <?php endif; ?>
                <?php endif; ?>


                

            </ul>

            <ul>
                

                <?php $__currentLoopData = menu(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuKey => $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check($menu['permission'])): ?>
                        <?php if($menu['marketplace'] == 'YES' && $menu['disabled'] == 'NO'): ?>
                            <li>
                                <a href="<?php echo e(isset($menu['route_name']) ? route($menu['route_name'], $menu['params']) : 'javascript:;'); ?>"
                                    class="side-menu
                        <?php if(isset($menu['route_name'])): ?> <?php echo e(request()->routeIs($menu['route_name']) ? 'side-menu--active side-menu--open' : ''); ?> <?php endif; ?>">
                                    <div
                                        class="<?php if(isset($menu['route_name'])): ?> <?php echo e(request()->routeIs($menu['route_name']) ? 'mldl-active-menu' : 'flex items-center'); ?>

                            <?php else: ?>
                                flex items-center <?php endif; ?>">

                                        <div class="side-menu__icon">
                                            <i data-feather="<?php echo e($menu['icon']); ?>"></i>
                                        </div>
                                        <div class="side-menu__title">
                                            <?php echo e($menu['title']); ?>


                                            <?php if(isset($menu['counter_badge'])): ?>
                                                <span class="ml-1">
                                                    (<?php echo e($menu['counter_badge']); ?>)
                                                </span>
                                            <?php endif; ?>

                                            <?php if(isset($menu['sub_menu'])): ?>
                                                <i data-feather="chevron-down" class="side-menu__sub-icon"></i>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                </a>

                                <?php if(isset($menu['sub_menu'])): ?>
                                    <ul
                                        class="d-none
                                        <?php $__currentLoopData = $menu['sub_menu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subMenuKey => $subMenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(isset(active_menu_name()[Route::currentRouteName()])): ?>                       
                                                <?php echo e(active_menu_name()[Route::currentRouteName()] == $subMenu['active_route_name'] ? 'side-menu__sub-open' : ''); ?> 
                                            <?php endif; ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        ">
                                        <?php $__currentLoopData = $menu['sub_menu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subMenuKey => $subMenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($subMenu['disabled'] == 'NO'): ?>
                                                <li>
                                                    <a href="<?php echo e(isset($subMenu['route_name']) ? route($subMenu['route_name'], $subMenu['params']) : 'javascript:;'); ?>"
                                                        class="side-menu
                                    <?php if(isset($subMenu['route_name'])): ?> <?php echo e(request()->routeIs($subMenu['route_name']) ? 'side-menu--active' : ''); ?> <?php endif; ?>">

                                                        <div class="side-menu__icon">
                                                            <i data-feather="<?php echo e($subMenu['icon']); ?>"></i>
                                                        </div>
                                                        <div class="side-menu__title">
                                                            <?php echo e($subMenu['title']); ?>

                                                        </div>
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </ul>
                                <?php endif; ?>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <li>
                    <div id="google_translate_element"></div>
                </li>


            </ul>

        </nav>
        <!-- END: Side Menu -->
        <!-- BEGIN: Content -->
        <div class="content">
            <?php echo $__env->make('../layout/components/top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php if($errors->any()): ?>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center bg-blue-500 text-white text-sm font-bold px-4 py-3 mt-3" role="alert">
                        <svg class="fill-current w-4 h-4 mr-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                            <path
                                d="M12.432 0c1.34 0 2.01.912 2.01 1.957 0 1.305-1.164 2.512-2.679 2.512-1.269 0-2.009-.75-1.974-1.99C9.789 1.436 10.67 0 12.432 0zM8.309 20c-1.058 0-1.833-.652-1.093-3.524l1.214-5.092c.211-.814.246-1.141 0-1.141-.317 0-1.689.562-2.502 1.117l-.528-.88c2.572-2.186 5.531-3.467 6.801-3.467 1.057 0 1.233 1.273.705 3.23l-1.391 5.352c-.246.945-.141 1.271.106 1.271.317 0 1.357-.392 2.379-1.207l.6.814C12.098 19.02 9.365 20 8.309 20z" />
                        </svg>
                        <p><?php echo e($error); ?></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>


            <?php echo $__env->yieldContent('subcontent'); ?>


        </div>
        <!-- END: Content -->
        <i class="fa fa-plus icon-default"></i>

        <div class="floatingButtonWrap">
            <div class="floatingButtonInner">
                <a href="javascript:;" class="floatingButton">
                    <i data-feather="plus"></i>
                </a>
                <ul class="floatingMenu">
                    <li>
                        <a href="<?php echo e(route('smtp.index')); ?>"><?php echo e(__('New SMTP Server')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('sms.index')); ?>"><?php echo e(__('New SMS Provider')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('campaign.create')); ?>"><?php echo e(__('New Campaign')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('campaign.type', 'email')); ?>"><?php echo e(__('Email Campaign')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('campaign.type', 'sms')); ?>"><?php echo e(__('SMS Campaign')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('email.contacts.index')); ?>"><?php echo e(__('New Contact')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('group.create')); ?>"><?php echo e(__('New Group')); ?></a>
                    </li>
                </ul>
            </div>
        </div>
        <?php if(org('disable_chatgpt') != 1): ?>
            <div id="chatGptBody">

                <div id="chat-circle" class="btn btn-raised ChatGPTButtonT">
                    <div id="chat-overlay"></div>
                    <i data-feather="message-circle">Chat</i>
                </div>

                <div id="modal-overlay" class="hiddenChatgpt chat-box">
                    <div class="chat-box-header">
                        Chat GPT
                        <span id="modal-close-Chatgpt" class="chat-box-toggle"><i data-feather="x">Close</i></span>
                    </div>
                    <div class="chat-box-body">
                        <div class="chat-box-overlay">
                        </div>
                        <div class="chat-logs" id="chatGPTLogs">

                            

                            
                        </div>
                        <!--chat-log -->
                        <div id="chatLoadingHTML">
                        </div>
                        <input type="hidden" id="ChatGPTIcon" value="<?php echo e(filePath('chatgptlogo.png')); ?>">
                    </div>
                    <div class="chat-input">
                        <form id="chatFormId">
                            <input type="hidden" name="routeName" id="ChatGptRoute"
                                value="<?php echo e(route('chat.gpt.chat.store.floating')); ?>">
                            <input type="text" name="prompt" id="chatInput" class="ChatGPTInput"
                                placeholder="Send a message..." />
                            <button type="submit" class="chat-submit" id="chat-submit"><i
                                    data-feather="send">Send</i></button>
                        </form>
                    </div>
                </div>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../layout/main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanbir/office/maildoll/resources/views////layout/side-menu.blade.php ENDPATH**/ ?>