<header>
    <!-- Navbar -->
    <nav class="navbar fixed-top navbar-shadow navbar-scroll-autohide navbar-expand-lg navbar-light bg-white py-3">
        <div class="container">
            <!-- Logo -->
            <a class="navbar-brand order-lg-1 flex-grow-1" href="<?php echo e(route('frontend.index')); ?>" aria-label="Logo">
                <img class="logo d-flex" src="<?php echo e(logo()); ?>" alt="<?php echo e(orgName()); ?>" />
            </a>
            <!-- End Logo -->


            <!-- Navbar Action Button -->
            <div class="d-none d-md-flex align-items-center order-2 order-lg-2 justify-content-end mr-3 mr-lg-0">
                <?php if(auth()->guard()->guest()): ?>
                    <a class="btn btn-primary d-inline-flex align-items-center" href="<?php echo e(route('login')); ?>">
                        <i class="ri-shopping-cart-2-line ri-lg mr-2"></i>
                        <span class="editable is-modified" data-cid="70"
                            tabindex="1"><?php echo e(argonContent(70) ?? 'Login'); ?></span>
                    </a>
                <?php endif; ?>
                <?php if(auth()->guard()->check()): ?>
                    <a class="btn btn-primary d-inline-flex align-items-center" href="<?php echo e(route('dashboard')); ?>">
                        <i class="ri-user-line ri-lg mr-2"></i>
                        <span><?php echo e(Auth::user()->name); ?></span>
                    </a>
                <?php endif; ?>

            </div>
            <!-- End Navbar Action Button -->


            <!-- Navbar Toggler / Humberger Menu -->
            <button class="navbar-toggler d-lg-none d-flex align-items-center order-3 order-lg-3" type="button"
                data-toggle="collapse" data-target="#navbar" aria-controls="navbar" aria-expanded="false"
                aria-label="Toggle navigation">
                <i class="ri-menu-3-fill ri-xl"></i>
            </button>
            <!-- End Navbar Toggler / Humberger Menu -->

            <!-- Navbar Menu -->
            <div class="collapse navbar-collapse order-3 order-lg-1 mr-lg-3" id="navbar">
                <ul class="navbar-nav ml-auto">
                    <!-- Nav Item -->
                    <li class="nav-item">
                        <a class="nav-link editable is-modified" href="<?php echo e(route('frontend.index')); ?>" data-cid="71"
                            tabindex="1"><?php echo e(argonContent(71) ?? 'Home'); ?></a>
                    </li>
                    <!-- End Nav Item -->

                    <!-- Nav Item -->
                    <?php $__currentLoopData = allPages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a class="nav-link editable is-modified" href="<?php echo e(url('page/' . $page->slug)); ?>"
                                data-cid="72" tabindex="1"><?php echo e($page->title); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <!-- End Nav Item -->

                    <!-- Nav Item -->
                    <li class="nav-item">
                        <a class="nav-link editable is-modified" href="#features" data-cid="73" tabindex="1">
                            <?php echo e(argonContent(73) ?? 'Features'); ?>

                        </a>
                    </li>
                    <!-- End Nav Item -->

                    <!-- Nav Item -->
                    <?php if(disableAtSaaS()): ?>
                        <?php if(displaySubscriptionPlan() > 0): ?>
                            <li class="nav-item">
                                <a class="nav-link editable is-modified" href="#pricing" data-cid="74" tabindex="1">
                                    <?php echo e(argonContent(74) ?? 'Pricing'); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    <!-- End Nav Item -->

                    <!-- Nav Item -->
                    <li class="nav-item">
                        <a class="nav-link editable is-modified" href="<?php echo e(route('frontend.blog.index')); ?>"
                            data-cid="75" tabindex="1">
                            <?php echo e(argonContent(75) ?? 'Blogs'); ?>

                        </a>
                    </li>
                    <!-- Nav Item -->
                   <?php if(env('DISABLE_CONTACT_FORM')=='NO'): ?>
                    <li class="nav-item">
                        <a class="nav-link editable is-modified" href="<?php echo e(route('contact.create')); ?>">
                            Contact Us
                        </a>
                    </li>
                   <?php endif; ?>
                    
                    <!-- End Nav Item -->

                    <?php if(env('MARKETPLACE') == 'YES'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('marketplace.frontend')); ?>"
                                target="_blank">Marketplace</a>
                        </li>
                    <?php endif; ?>

                    <?php if(auth()->guard()->guest()): ?>
                        <li class="nav-item d-none">
                            <a class="nav-link editable is-modified" href="<?php echo e(route('login')); ?>" data-cid="76"
                                tabindex="1">
                                <?php echo e(argonContent(76) ?? 'Login'); ?>

                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(auth()->guard()->check()): ?>
                        <li class="nav-item d-none">
                            <a class="nav-link" href="<?php echo e(route('dashboard')); ?>">
                                <?php echo e(Auth::user()->name); ?>

                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if(auth()->guard()->guest()): ?>
                        <li class="nav-item d-md-none">
                            <a class="nav-link editable is-modified" href="<?php echo e(route('login')); ?>" data-cid="78"
                                tabindex="1">
                                <?php echo e(argonContent(78) ?? 'Login'); ?>

                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if(auth()->guard()->check()): ?>
                        <li class="nav-item d-md-none">
                            <a class="btn btn-primary d-inline-flex align-items-center" href="<?php echo e(route('dashboard')); ?>">
                                <?php echo e(Str::upper(Auth::user()->name)); ?>

                            </a>
                        </li>
                    <?php endif; ?>

                </ul>
            </div>
            <!-- End Navbar Menu -->
        </div>
    </nav>
    <!-- End Navbar -->
</header>
<?php /**PATH /home/tanbir/office/maildoll/resources/views/frontend/argon/components/header.blade.php ENDPATH**/ ?>