<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubscriptionPlansTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('subscription_plans', function (Blueprint $table) {
            $table->id();
            $table->longText('name');
            $table->string('duration');
            $table->string('emails');
            $table->string('sms');
            $table->longText('description');
            $table->double('price');
            $table->boolean('status')->default(true);
            $table->boolean('display')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('subscription_plans');
    }
}
